<?php
$pageTitle = 'Daftar Tiket Dukungan';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$initialStatusFilter = $_GET['status'] ?? 'all';
$statusOptions = [
    'all' => 'Semua Status',
    'open' => 'Terbuka',
    'answered' => 'Dijawab Admin',
    'user_reply' => 'Balasan Anda',
    'closed' => 'Ditutup'
];
?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-life-ring mr-3 text-orange-500"></i> Tiket Dukungan
        </h2>
        <div class="flex items-center space-x-2">
             <a href="<?php echo base_url('tickets/create'); ?>"
               class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg shadow hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition">
                <i class="fas fa-plus mr-1"></i> Buat Tiket Baru
            </a>
        </div>
    </div>

    <div id="ticket-list-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID Tiket</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Subjek</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Update Terakhir</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="ticket-list-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="5" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat daftar tiket...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="ticket-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="ticket-pagination-info">Menampilkan 0 hasil.</div>
            <div id="ticket-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1">
                 </div>
        </div>
    </div>

     </main>
