<?php
$pageTitle = 'Daftar Layanan';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$initialSearchKeyword = $_GET['search'] ?? '';
$initialSortBy = 's.name'; 
$initialSortType = 'ASC';

$sortColumnOptions = [
    's.name' => 'Nama Layanan',
    's.price_per_1000' => 'Harga',
    'c.name' => 'Kategori', 
    's.id' => 'ID Layanan'
];
$sortTypeOptions = ['ASC' => 'A-Z / Termurah', 'DESC' => 'Z-A / Termahal'];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-6 bg-gradient-to-b from-gray-100 to-gray-200">
    <div class="max-w-7xl mx-auto">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-3">
            <h2 class="text-2xl font-semibold text-gray-800 flex items-center">
                <i class="fas fa-stream mr-3 text-indigo-600"></i> Daftar Layanan Kami
            </h2>
            <div class="flex items-center space-x-2">
                 <button type="button" id="service-filter-modal-button"
                        class="px-4 py-2.5 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all duration-150 ease-in-out">
                    <i class="fas fa-filter mr-2"></i> Filter & Urutkan
                </button>
                 <a href="<?php echo base_url('order/create'); ?>"
                   class="px-4 py-2.5 text-sm font-medium text-white bg-gradient-to-r from-indigo-600 to-purple-600 rounded-lg shadow-md hover:from-indigo-700 hover:to-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all duration-150 ease-in-out transform hover:scale-105">
                    <i class="fas fa-cart-plus mr-2"></i> Buat Pesanan
                </a>
            </div>
        </div>

        <div id="service-list-message" class="mb-6 text-sm"></div>

        <div id="service-list-loading" class="text-center py-16 text-gray-500">
            <i class="fas fa-circle-notch fa-spin text-5xl text-indigo-500 mb-4"></i>
            <p class="text-lg font-medium">Memuat daftar layanan...</p>
            <p class="text-sm">Mohon tunggu sebentar.</p>
        </div>

        <div id="service-list-container" class="space-y-8">
            
        </div>
    </div>

    
    <div id="service-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-70 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="service-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-xl shadow-2xl w-full max-w-lg mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="service-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="service-filter-modal-title">
                    <i class="fas fa-sliders-h mr-3 text-indigo-400"></i> Filter Daftar Layanan
                </h3>
                <button type="button" id="close-service-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <form id="service-filter-form" class="p-6 space-y-5">
                 <div>
                    <label for="filter_search_keyword" class="block text-sm font-medium text-gray-300 mb-1.5">Cari Layanan</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 pl-3.5 flex items-center pointer-events-none">
                            <i class="fas fa-search text-gray-400 text-xs"></i>
                        </span>
                        <input type="text" id="filter_search_keyword" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchKeyword); ?>" placeholder="Nama layanan atau ID..."
                               class="w-full pl-10 pr-3 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-colors">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label for="filter_sort_by" class="block text-sm font-medium text-gray-300 mb-1.5">Urutkan Berdasarkan</label>
                        <select id="filter_sort_by" name="sort_by" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-colors">
                            <?php foreach ($sortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === $initialSortBy) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type" class="block text-sm font-medium text-gray-300 mb-1.5">Tipe Urutan</label>
                        <select id="filter_sort_type" name="sort_type" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition-colors">
                             <?php foreach ($sortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === $initialSortType) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                 <div class="flex justify-end items-center pt-5 space-x-3 border-t border-gray-700 mt-6">
                     <button type="button" id="reset-service-filter-button" class="px-5 py-2.5 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition-colors duration-150">Reset</button>
                     <button type="submit" id="apply-service-filter-button" class="px-6 py-2.5 text-sm font-medium text-white bg-gradient-to-r from-indigo-500 to-purple-500 rounded-lg shadow-md hover:from-indigo-600 hover:to-purple-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-indigo-500 transition-all duration-150 transform hover:scale-105"><i class="fas fa-check-circle mr-2"></i> Terapkan Filter</button>
                 </div>
            </form>
        </div>
    </div>
    
    <div id="service-detail-modal" class="fixed inset-0 z-[60] hidden items-center justify-center bg-black bg-opacity-75 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="service-detail-modal-title" role="dialog" aria-modal="true">
         <div class="relative bg-gray-800 rounded-xl shadow-2xl w-full max-w-lg mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0 flex flex-col max-h-[85vh]" id="service-detail-modal-content">
             <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700 flex-shrink-0">
                 <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="service-detail-modal-title-text"><i class="fas fa-info-circle mr-3 text-indigo-400"></i> Detail Layanan</h3>
                 <button type="button" id="close-service-detail-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
             </div>
             <div class="p-6 space-y-4 text-sm overflow-y-auto flex-grow" id="service-detail-modal-body">
                 <div class="flex justify-center items-center h-32">
                    <i class="fas fa-circle-notch fa-spin text-3xl text-gray-400"></i>
                </div>
             </div>
             <div class="px-6 py-4 bg-gray-750 border-t border-gray-700 rounded-b-xl flex justify-end flex-shrink-0">
                  <button type="button" id="close-service-detail-modal-footer" class="px-5 py-2.5 text-sm font-medium text-gray-200 bg-red-600 hover:bg-red-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-red-500 transition-colors duration-150">Tutup</button>
             </div>
         </div>
     </div>

</main>