<?php
$pageTitle = 'Pengaturan Akun';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$auth = new Auth($pdo); 
$currentUser = $auth->getUserById($_SESSION['user_id']);

if (!$currentUser) {
    Auth::logout();
    redirect(base_url('login?error=user_not_found'));
}

$userFullname = $currentUser['full_name'] ?? '';
$userPhoneNumber = $currentUser['phone_number'] ?? '';
$userEmail = $currentUser['email'] ?? '';
$userUsername = $currentUser['username'] ?? '';

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <h2 class="text-2xl font-semibold text-gray-700 mb-6 flex items-center">
        <i class="fas fa-user-cog mr-3 text-blue-500"></i> Pengaturan Akun
    </h2>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

        <div class="lg:col-span-2">
            <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100 mb-6">
                <h3 class="text-xl font-semibold text-gray-800 mb-5 border-b pb-3">Informasi Profil</h3>

                <div id="profile-info-message" class="mb-4 text-sm"></div>

                <form id="profile-info-form" method="POST" class="space-y-4">
                    <input type="hidden" name="action" value="update_info">

                    <div>
                        <label for="username" class="block text-sm font-medium text-gray-500 mb-1">Username</label>
                        <input id="username" name="username" type="text" readonly disabled
                               value="<?php echo htmlspecialchars($userUsername); ?>"
                               class="input-field block w-full px-4 py-2.5 border border-gray-200 bg-gray-100 text-gray-500 rounded-lg shadow-sm sm:text-sm cursor-not-allowed" />
                        <p class="text-xs text-gray-400 mt-1">Username tidak dapat diubah.</p>
                    </div>

                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-500 mb-1">Email</label>
                        <input id="email" name="email" type="email" readonly disabled
                               value="<?php echo htmlspecialchars($userEmail); ?>"
                               class="input-field block w-full px-4 py-2.5 border border-gray-200 bg-gray-100 text-gray-500 rounded-lg shadow-sm sm:text-sm cursor-not-allowed" />
                         <p class="text-xs text-gray-400 mt-1">Email tidak dapat diubah.</p>
                    </div>

                    <div>
                        <label for="full_name" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input id="full_name" name="full_name" type="text"
                               value="<?php echo htmlspecialchars($userFullname); ?>" placeholder="Masukkan nama lengkap Anda"
                               class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                        <span id="full_name-error" class="text-red-500 text-xs mt-1"></span>
                    </div>

                    <div>
                        <label for="phone_number" class="block text-sm font-medium text-gray-700 mb-1">Nomor Handphone</label>
                        <input id="phone_number" name="phone_number" type="tel"
                               value="<?php echo htmlspecialchars($userPhoneNumber); ?>" placeholder="Contoh: 08123456789"
                               class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                        <span id="phone_number-error" class="text-red-500 text-xs mt-1"></span>
                         <p class="text-xs text-gray-400 mt-1">Gunakan format angka saja, contoh: 0812xxxxxxxx.</p>
                    </div>

                    <div class="pt-4">
                        <button type="submit" id="update-info-button"
                                class="inline-flex justify-center py-2.5 px-5 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                            <i class="fas fa-save mr-2"></i> <span id="update-info-button-text">Simpan Informasi</span>
                            <i id="update-info-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100">
                <h3 class="text-xl font-semibold text-gray-800 mb-5 border-b pb-3">Ganti Password</h3>

                 <div id="password-change-message" class="mb-4 text-sm"></div>

                <form id="password-change-form" method="POST" class="space-y-4">
                     <input type="hidden" name="action" value="change_password">

                    <div>
                        <label for="current_password" class="block text-sm font-medium text-gray-700 mb-1">Password Saat Ini <span class="text-red-500">*</span></label>
                        <div class="relative">
                            <input id="current_password" name="current_password" type="password" required placeholder="Masukkan password Anda saat ini"
                                   class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out pr-10" />
                             <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none text-gray-400 hover:text-gray-600 password-toggle-btn" data-target="current_password">
                                 <i class="fas fa-eye"></i>
                             </button>
                        </div>
                        <span id="current_password-error" class="text-red-500 text-xs mt-1"></span>
                    </div>

                    <div>
                        <label for="new_password" class="block text-sm font-medium text-gray-700 mb-1">Password Baru <span class="text-red-500">*</span></label>
                         <div class="relative">
                            <input id="new_password" name="new_password" type="password" required placeholder="Minimal 6 karakter"
                                   class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out pr-10" />
                             <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none text-gray-400 hover:text-gray-600 password-toggle-btn" data-target="new_password">
                                 <i class="fas fa-eye"></i>
                             </button>
                        </div>
                        <span id="new_password-error" class="text-red-500 text-xs mt-1"></span>
                    </div>

                    <div>
                        <label for="confirm_new_password" class="block text-sm font-medium text-gray-700 mb-1">Konfirmasi Password Baru <span class="text-red-500">*</span></label>
                         <div class="relative">
                            <input id="confirm_new_password" name="confirm_new_password" type="password" required placeholder="Ketik ulang password baru"
                                   class="input-field block w-full px-4 py-2.5 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out pr-10" />
                             <button type="button" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none text-gray-400 hover:text-gray-600 password-toggle-btn" data-target="confirm_new_password">
                                 <i class="fas fa-eye"></i>
                             </button>
                        </div>
                        <span id="confirm_new_password-error" class="text-red-500 text-xs mt-1"></span>
                    </div>

                     <div class="pt-4">
                        <button type="submit" id="change-password-button"
                                class="inline-flex justify-center py-2.5 px-5 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-orange-600 hover:bg-orange-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-orange-500 transition duration-150 ease-in-out">
                            <i class="fas fa-key mr-2"></i> <span id="change-password-button-text">Ganti Password</span>
                            <i id="change-password-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

         <div class="lg:col-span-1">
             <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100 h-fit sticky top-24">
                <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-shield-alt text-green-500 mr-2"></i> Keamanan Akun
                </h3>
                <div class="space-y-3 text-sm text-gray-600">
                    <p>Jaga kerahasiaan password Anda dan gunakan kombinasi yang kuat.</p>
                    <p>Hindari menggunakan password yang sama di website lain.</p>
                    <p>Pastikan nomor handphone Anda aktif untuk pemulihan akun (jika fitur diaktifkan).</p>
                    <a href="<?php echo base_url('settings/2fa'); ?>" class="mt-3 inline-block text-blue-600 hover:underline">Aktifkan Otentikasi Dua Faktor <i class="fas fa-arrow-right text-xs ml-1"></i></a>
                </div>
            </div>
        </div>

    </div>
</main>
