<?php
$userFullname = $_SESSION['user_fullname'] ?? 'Pengguna';
$userEmail = $_SESSION['user_email'] ?? '';
?>
<header class="bg-white shadow-md p-4 flex justify-between items-center border-b border-gray-200 z-10">
    <div class="flex items-center">
        <button id="hamburger-button" class="lg:hidden text-gray-500 hover:text-blue-600 focus:outline-none mr-4">
            <i class="fas fa-bars text-xl"></i>
        </button>
        <h1 class="text-lg font-semibold text-gray-700"><?php echo htmlspecialchars($pageTitle ?? 'Dashboard'); ?></h1>
    </div>

    <div class="flex items-center space-x-5">
         <div class="relative hidden md:block">
            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                <i class="fas fa-search text-gray-400"></i>
            </span>
            <input type="text" placeholder="Cari..." class="w-full pl-10 pr-4 py-2 text-sm border border-gray-300 rounded-full focus:outline-none focus:ring-2 focus:ring-blue-400 focus:border-transparent bg-gray-50 focus:bg-white">
        </div>

        <button class="relative text-gray-500 hover:text-blue-600 focus:outline-none">
            <i class="far fa-bell text-xl"></i>
            <span class="absolute top-0 right-0 block h-2.5 w-2.5 rounded-full bg-red-500 ring-2 ring-white"></span>
        </button>

         <div class="relative">
            <button id="profile-button" class="flex items-center focus:outline-none space-x-2">
                <img src="https://placehold.co/36x36/e0e7ff/4f46e5?text=<?php echo strtoupper(substr($userFullname, 0, 1)); ?>" alt="User Avatar" class="w-9 h-9 rounded-full border-2 border-transparent hover:border-blue-300 transition-colors">
                 <span class="hidden md:inline text-sm font-medium text-gray-600"><?php echo htmlspecialchars($userFullname); ?></span>
                <i class="fas fa-chevron-down text-xs text-gray-500 hidden md:inline"></i>
            </button>
            <div id="profile-dropdown" class="profile-dropdown">
                <div class="p-4 border-b border-gray-700">
                    <h3 class="text-sm font-semibold text-gray-300 mb-3">Profile</h3>
                    <div class="flex items-center space-x-3">
                        <img class="h-10 w-10 rounded-full object-cover" src="https://placehold.co/40x40/e0e7ff/4f46e5?text=<?php echo strtoupper(substr($userFullname, 0, 1)); ?>" alt="<?php echo htmlspecialchars($userFullname); ?> Avatar">
                        <div>
                            <p class="text-sm font-semibold text-white truncate" title="<?php echo htmlspecialchars($userFullname); ?>"><?php echo htmlspecialchars($userFullname); ?> <i class="fas fa-star text-yellow-400 text-xs ml-1"></i></p> <?php  ?>
                            <p class="text-xs text-blue-300 truncate" title="<?php echo htmlspecialchars($userEmail); ?>"><?php echo htmlspecialchars($userEmail); ?></p>
                        </div>
                    </div>
                </div>
                <nav class="py-2 px-2 space-y-1">
                    <a href="<?php echo base_url('settings/api'); ?>" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-white/10 hover:text-white rounded-md transition-colors">
                        <i class="fas fa-key w-5 text-center mr-3 text-gray-400"></i> Pengaturan API
                    </a>
                    <a href="<?php echo base_url('profile/settings'); ?>" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-white/10 hover:text-white rounded-md transition-colors">
                        <i class="fas fa-user-cog w-5 text-center mr-3 text-gray-400"></i> Pengaturan Akun
                    </a>
                </nav>
                <div class="p-2 border-t border-gray-700">
                    <a href="<?php echo base_url('logout'); ?>" class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 rounded-md transition-colors">
                        <i class="fas fa-sign-out-alt w-4 mr-2"></i>Logout
                    </a>
                </div>
            </div>
        </div>
    </div>
</header>
