<?php
$pageTitle = 'Dokumentasi API';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }
global $appSettings;
$apiBaseUrl = rtrim(base_url(), '/') . '/api/v1';
?>

<main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-6 bg-gradient-to-b from-gray-800 to-gray-900 text-gray-200">
    <div class="max-w-4xl mx-auto">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-2xl sm:text-3xl font-bold text-white flex items-center">
                <i class="fas fa-code mr-3 text-purple-400"></i> Dokumentasi API - v1
            </h2>
        </div>

        <div class="bg-gray-800 border border-gray-700 shadow-2xl rounded-xl p-6 md:p-8 space-y-10">

            <section id="api-introduction">
                <h3 class="text-xl font-semibold text-purple-300 mb-3 border-b border-gray-700 pb-2">Pendahuluan</h3>
                <p class="text-sm text-gray-300 leading-relaxed">
                    Selamat datang di dokumentasi API <?php echo htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel'); ?>. API ini memungkinkan Anda untuk mengintegrasikan layanan kami ke dalam platform atau aplikasi Anda sendiri secara terprogram. Semua permintaan API harus dilakukan ke URL dasar berikut dan semua respons akan dalam format JSON.
                </p>
                <div class="mt-4">
                    <p class="text-xs text-gray-400 mb-1">URL Dasar API (v1):</p>
                    <code class="block bg-gray-700 text-purple-300 p-3 rounded-md text-sm break-all"><?php echo htmlspecialchars($apiBaseUrl); ?></code>
                </div>
            </section>

            <section id="api-authentication">
                <h3 class="text-xl font-semibold text-purple-300 mb-3 border-b border-gray-700 pb-2">Otentikasi</h3>
                <p class="text-sm text-gray-300 leading-relaxed">
                    Setiap permintaan ke API kami memerlukan otentikasi menggunakan API Key unik Anda. Anda dapat menemukan atau membuat API Key Anda di halaman <a href="<?php echo base_url('profile/settings'); ?>#api-key-section" class="text-indigo-400 hover:text-indigo-300 underline">Pengaturan Akun</a>.
                </p>
                <p class="text-sm text-gray-300 mt-2 leading-relaxed">
                    Sertakan API Key Anda dalam setiap permintaan POST sebagai parameter <code class="bg-gray-700 px-1.5 py-0.5 rounded-md text-xs text-purple-300">api_key</code>.
                </p>
                <div class="mt-3 p-4 bg-yellow-900 bg-opacity-30 border border-yellow-700 rounded-lg text-yellow-200 text-xs">
                    <i class="fas fa-exclamation-triangle mr-2"></i> Jaga kerahasiaan API Key Anda. Jangan pernah membagikannya atau menampilkannya di sisi klien (frontend).
                </div>
            </section>

            <section id="api-endpoints" class="space-y-8">
                <h3 class="text-xl font-semibold text-purple-300 mb-4 border-b border-gray-700 pb-2">Endpoint API</h3>

                <div class="api-endpoint-item bg-gray-750 p-5 rounded-lg border border-gray-600 shadow-md">
                    <h4 class="text-lg font-medium text-indigo-300 mb-1">Daftar Layanan</h4>
                    <p class="text-xs text-gray-400 mb-3">Mengambil daftar semua layanan yang aktif.</p>
                    <div class="mb-3">
                        <span class="inline-block bg-green-600 text-white text-xs font-semibold px-2.5 py-1 rounded-full mr-2">POST</span>
                        <code class="text-sm text-gray-300"><?php echo htmlspecialchars($apiBaseUrl); ?>/services</code>
                    </div>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Parameter Permintaan (POST):</p>
                    <ul class="list-disc list-inside text-xs text-gray-400 pl-4 space-y-1 mb-3">
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">api_key</code> (string, wajib): Kunci API Anda.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">action</code> (string, wajib): Harus bernilai <code class="bg-gray-600 px-1 rounded text-purple-300">services</code>.</li>
                    </ul>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Contoh Respons Sukses (JSON):</p>
                    <pre class="bg-gray-900 text-xs text-gray-300 p-3 rounded-md overflow-x-auto custom-scrollbar"><code class="language-json">{
    "success": true,
    "data": [
        {
            "service_id": "101",
            "category": "Instagram Followers",
            "name": "Instagram Followers [REAL INDO]",
            "price_per_1000": "15000.00",
            "min_order": "100",
            "max_order": "10000"
        },
        {
            "service_id": "102",
            "category": "Instagram Likes",
            "name": "Instagram Likes [FAST]",
            "price_per_1000": "5000.00",
            "min_order": "50",
            "max_order": "5000"
        }
        // ... layanan lainnya
    ]
}</code></pre>
                </div>

                <div class="api-endpoint-item bg-gray-750 p-5 rounded-lg border border-gray-600 shadow-md">
                    <h4 class="text-lg font-medium text-indigo-300 mb-1">Buat Pesanan</h4>
                    <p class="text-xs text-gray-400 mb-3">Membuat pesanan baru untuk layanan tertentu.</p>
                    <div class="mb-3">
                        <span class="inline-block bg-green-600 text-white text-xs font-semibold px-2.5 py-1 rounded-full mr-2">POST</span>
                        <code class="text-sm text-gray-300"><?php echo htmlspecialchars($apiBaseUrl); ?>/order</code>
                    </div>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Parameter Permintaan (POST):</p>
                    <ul class="list-disc list-inside text-xs text-gray-400 pl-4 space-y-1 mb-3">
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">api_key</code> (string, wajib): Kunci API Anda.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">action</code> (string, wajib): Harus bernilai <code class="bg-gray-600 px-1 rounded text-purple-300">add</code>.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">service</code> (integer, wajib): ID Layanan (dari endpoint Daftar Layanan).</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">target</code> (string, wajib): Target pesanan (misal: username, link postingan).</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">quantity</code> (integer, wajib): Jumlah pesanan.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">custom_comments</code> (string, opsional): Komentar kustom, jika layanan mendukung. Pisahkan dengan baris baru.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">custom_link</code> (string, opsional): Link kustom, jika layanan mendukung.</li>
                    </ul>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Contoh Respons Sukses (JSON):</p>
                    <pre class="bg-gray-900 text-xs text-gray-300 p-3 rounded-md overflow-x-auto custom-scrollbar"><code class="language-json">{
    "success": true,
    "data": {
        "order_id": "50123" // ID Pesanan internal kami
    },
    "message": "Pesanan berhasil dibuat."
}</code></pre>
                    <p class="text-sm font-medium text-gray-300 mt-3 mb-1.5">Contoh Respons Gagal (JSON):</p>
                    <pre class="bg-gray-900 text-xs text-gray-300 p-3 rounded-md overflow-x-auto custom-scrollbar"><code class="language-json">{
    "success": false,
    "error": "Saldo tidak mencukupi."
}</code></pre>
                </div>

                <div class="api-endpoint-item bg-gray-750 p-5 rounded-lg border border-gray-600 shadow-md">
                    <h4 class="text-lg font-medium text-indigo-300 mb-1">Status Pesanan</h4>
                    <p class="text-xs text-gray-400 mb-3">Mengambil status pesanan tertentu.</p>
                    <div class="mb-3">
                        <span class="inline-block bg-green-600 text-white text-xs font-semibold px-2.5 py-1 rounded-full mr-2">POST</span>
                        <code class="text-sm text-gray-300"><?php echo htmlspecialchars($apiBaseUrl); ?>/status</code>
                    </div>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Parameter Permintaan (POST):</p>
                    <ul class="list-disc list-inside text-xs text-gray-400 pl-4 space-y-1 mb-3">
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">api_key</code> (string, wajib): Kunci API Anda.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">action</code> (string, wajib): Harus bernilai <code class="bg-gray-600 px-1 rounded text-purple-300">status</code>.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">order_id</code> (integer, wajib): ID Pesanan yang ingin dicek statusnya.</li>
                    </ul>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Contoh Respons Sukses (JSON):</p>
                    <pre class="bg-gray-900 text-xs text-gray-300 p-3 rounded-md overflow-x-auto custom-scrollbar"><code class="language-json">{
    "success": true,
    "data": {
        "order_id": "50123",
        "status": "Processing", // Bisa Pending, Processing, In Progress, Success, Partial, Error, Canceled
        "start_count": "1000",
        "remains": "500",
        "quantity": "1000"
    }
}</code></pre>
                </div>
                
                <div class="api-endpoint-item bg-gray-750 p-5 rounded-lg border border-gray-600 shadow-md">
                    <h4 class="text-lg font-medium text-indigo-300 mb-1">Saldo Pengguna</h4>
                    <p class="text-xs text-gray-400 mb-3">Mengambil informasi saldo pengguna saat ini.</p>
                    <div class="mb-3">
                        <span class="inline-block bg-green-600 text-white text-xs font-semibold px-2.5 py-1 rounded-full mr-2">POST</span>
                        <code class="text-sm text-gray-300"><?php echo htmlspecialchars($apiBaseUrl); ?>/balance</code>
                    </div>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Parameter Permintaan (POST):</p>
                    <ul class="list-disc list-inside text-xs text-gray-400 pl-4 space-y-1 mb-3">
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">api_key</code> (string, wajib): Kunci API Anda.</li>
                        <li><code class="bg-gray-600 px-1 rounded text-purple-300">action</code> (string, wajib): Harus bernilai <code class="bg-gray-600 px-1 rounded text-purple-300">balance</code>.</li>
                    </ul>
                    <p class="text-sm font-medium text-gray-300 mb-1.5">Contoh Respons Sukses (JSON):</p>
                    <pre class="bg-gray-900 text-xs text-gray-300 p-3 rounded-md overflow-x-auto custom-scrollbar"><code class="language-json">{
    "success": true,
    "data": {
        "balance": "50000.00", // Saldo dalam format string
        "currency": "IDR"
    }
}</code></pre>
                </div>

            </section>

            <section id="api-status-codes">
                <h3 class="text-xl font-semibold text-purple-300 mb-3 border-b border-gray-700 pb-2">Kode Status Respons</h3>
                <p class="text-sm text-gray-300 leading-relaxed mb-2">
                    API kami menggunakan kode status HTTP standar untuk mengindikasikan keberhasilan atau kegagalan permintaan API.
                </p>
                <ul class="list-disc list-inside text-xs text-gray-400 pl-4 space-y-1">
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">200 OK</code>: Permintaan berhasil.</li>
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">400 Bad Request</code>: Permintaan tidak valid (misalnya, parameter hilang atau salah format).</li>
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">401 Unauthorized</code>: Kunci API tidak valid atau tidak diberikan.</li>
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">403 Forbidden</code>: Anda tidak memiliki izin untuk mengakses sumber daya ini.</li>
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">404 Not Found</code>: Endpoint API tidak ditemukan.</li>
                    <li><code class="bg-gray-600 px-1 rounded text-purple-300">500 Internal Server Error</code>: Terjadi kesalahan di server kami.</li>
                </ul>
            </section>

        </div>
    </div>
</main>
<style>
    .custom-scrollbar::-webkit-scrollbar {
        height: 6px;
        background-color: #1f2937;
    }
    .custom-scrollbar::-webkit-scrollbar-thumb {
        background-color: #4b5563; 
        border-radius: 3px;
    }
    .custom-scrollbar::-webkit-scrollbar-thumb:hover {
        background-color: #6b7280; 
    }
    .api-endpoint-item {
        transition: all 0.3s ease-in-out;
    }
    .api-endpoint-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.2), 0 0 15px rgba(120,81,255,0.3);
    }
</style>